package centralSystemOld;

/**
 * {@link ICentralSystem} interface is an abstract 
 * representation for a Post Office System, able to
 * keep in communication each software part of the 
 * entire Office, like queues, counters, displays...
 * 
 * @author simone
 *
 */
public interface ICentralSystem {

	/**
	 * Add a new client in a specified {@link Queue},
	 * with a consequent increase in number of 
	 * awaiting clients (for that specificid queue) 
	 * 
	 * @param index: integer representing the queue
	 */
	public void addClientAtQueue(int index);

	/**
	 * Causes a decrease in the number of awaiting
	 * clients in a specified cue.
	 * 
	 * @param index: integer representing the queue
	 */
	public void clientServedAtQueue(int index);

	/**
	 * 
	 * @param index: integer representing a queue
	 * @return: number of clients added to that queue
	 * since systems' initialization
	 */
	public int getTotalClient(int index);

	/**
	 * 
	 * @param index: integer representing a queue
	 * @return: next client to be served at that queue
	 */
	public int getNextClient(int index);

}